import matplotlib.pyplot as plt
import numpy as np
from scipy.interpolate import interp1d
# 数据
data = """162.577515
238.772086
245.606123
117.490808
193.941073
169.077328
85.818897
241.378527
156.753141
215.32735
329.866103
146.740794
49.340247
72.743408
195.457521
211.06053
443.097091
204.898926
124.744454
293.997252
168.583387
125.825257
186.036659
100.731498
110.671121
174.634868
229.262398
300.21168
120.570402
107.099672
329.742653
262.55907
313.934424
243.3988
389.817688
329.140196
212.681122
137.637499
76.575787
155.908879
222.466491
200.290755
107.475269
187.994143
198.472152
241.905285
264.692672
148.079557
193.705004
232.088516
148.804005
118.072526
106.666508
360.189459
229.935623
215.417097
311.718681
239.133357
186.503812
205.155829
106.724888
360.530107
294.724461
285.311689
187.602808
183.167488
242.387839
236.227534
266.110799
251.714608
289.882193
245.709029
324.189064
177.135173
325.872289
226.682551
320.718047
165.209964
223.058974
176.921667
273.603198
184.114174
328.724742
119.804079
162.459799
192.732526
161.792802
113.680623
270.816095
183.817499
313.432031
177.647387
255.845278
265.464282
121.365493
213.626423
229.644829
271.971485
131.705106
267.771328
49.491074
167.481336
120.766724
296.593273
151.819131
231.866216
180.425906
251.13728
192.994468
119.020307
256.47592
164.948545
291.421638
282.789956
182.913504
371.097398
187.309245
154.960013
193.303126
231.728649
300.266699
297.583912
165.705815
283.645353
200.703098
263.359767
202.978254
285.788672
385.425881
167.151965
247.397255
160.080619
266.806005
220.875317
161.146538
162.784525
210.185012
189.00832
210.90179
270.155115
142.633487
200.435559
241.845202
253.7244
408.877182
403.573766
343.621782
152.551243
252.042308
322.118521
271.949517
372.507783
185.770148
235.00706
286.996479
269.305215
394.565105
318.564322
169.638652
131.905307
158.932007
142.173976
76.527057
307.659616
204.590551
249.256594
433.431162
345.422172
186.734927
296.334253
321.304227
287.190589
280.694556
258.905034
397.816219
305.325143
358.100793
436.010105
326.776585
238.706761
62.002723
386.978561
279.460877
240.689806
372.536819
323.686734
382.730427
301.116613
170.260921
234.457647
303.350053
374.728765
234.081974
369.182795
420.887534
161.495386
172.730635
112.520705
406.461535
248.217093
279.283676
128.884139
312.035767
259.582759
143.265634
314.475405
293.339236
278.521793
407.010776
285.933555
372.94037
251.092329
366.688348
177.728589
454.655668
244.169872
154.987352
258.34172
334.181737
225.64543
157.821236
341.699808
383.585716
467.796349
323.574106
420.346135
225.412175
266.086063
104.599445
205.818183
213.03769
394.240636
159.716026
253.684165
287.786623
278.403447
301.698095
281.779229
330.955866
62.727952
142.853557
69.542539
175.740595
119.594603
298.714129
113.801201
447.754771
171.732502
514.441102
387.707451
130.588847
227.968702
86.571725
318.017657
282.089057
428.141818
435.397221
339.856023
391.18229
251.347125
318.289318
549.616544
550.844168
485.110241
385.630109
368.481582
86.04646
464.833777
598.796403
164.514684
345.591058
425.031619
333.761034
130.509932
496.45683
361.156468
544.859999
545.141607
124.713953
467.994161
78.666215
176.153532
144.274765
125.60079
96.171768
89.471734
385.162527
380.496764
541.608101
308.832195
334.190728
320.155383
312.613209
566.831312
545.879002
69.214296
525.377281
574.650004
451.214923
273.578458
475.672664
365.667452
117.574759
144.629943
566.414855
62.376041
402.196516
422.418628
405.802858
452.703476
326.825707
439.561463
465.624652
411.88147
114.039621
196.148139
99.959555
148.625744
453.769593
191.387462
76.436584
454.905925
124.992278
125.415867
484.217609
143.009423
463.38388
566.506144
416.842171
389.489384
531.723592
131.425106
324.236868
99.279926
211.664251
182.14739
573.397753
354.446098
315.192572
154.030938
471.289945
102.882939
652.352588
387.130144
546.902856
427.258934
504.78817
708.968618
418.576998
62.45816
120.361184
573.643871
457.995226
486.101284
213.125348
571.045911
414.67384
524.344167
578.010061
509.120438
458.195456
521.329148
82.463517
526.65508
563.84066
466.613966
315.237346
453.786625
558.470724
269.563602
153.747559
148.078286
153.962221
607.696182
617.031706
613.046764
748.783068
688.465755
623.620566
356.703455
653.570503
697.961578
599.703258
56.612866
288.486958
612.171856
89.339286
591.201841
451.5942
585.224285
66.304394
633.305722
573.745377
663.362576
752.22495
656.101006
412.661076
784.646054
423.014491
681.786323
664.674508
542.58029
779.771796
757.6689
559.911619
119.836274
807.678241
515.219046
160.035941
580.628714
262.105176
100.135347
685.909518
621.550695
636.69519
103.067659
739.951562
515.448147
752.812416
697.247858
708.394055
822.644862
716.651917
815.832873
709.071447
677.483934
841.444167
820.24814
764.769683
742.162011
836.5404
539.730151
278.825528
448.155188
778.999682
901.427245
704.329117
473.452132
829.417853
866.554573
837.681691
608.894756
504.354412
710.638687
889.489111
787.673191
732.407316
733.807793
881.984266
845.510968
816.623442
896.561992
782.462832
827.756403
873.548112
825.395695
826.029003
921.655873
655.787911
826.361569
866.660269
664.768147
664.556234
877.708743
780.708121
894.572551
640.873631
857.234422
868.309077
773.499808
932.964962
849.700694
825.313418
799.998276
846.148582
932.693542
764.779056
613.301096
835.658753
892.453377
919.80995
161.602307
686.748658
584.222652
891.700979
759.621638
780.118443
945.127336
738.896246
762.905063
952.605676
901.607341
708.387737
877.33927
911.096267
534.805369
695.989956
949.42888
921.555678
875.307139
889.357671
916.611781
915.677485
924.768238
901.943696
904.852764
880.541602
956.086202
855.437791
568.006259
803.954469
956.590473
979.72931
230.315651
973.601535
904.749634
991.291679
893.939252
191.710139
948.620034
772.412476
737.193604
980.262912
957.97116
925.537943
940.106549
930.52418
810.679995
951.336845
954.229581
754.553515
819.383945
981.514083
791.871936
941.955323
927.932527
969.609977
796.793807
940.481943
917.98053
980.160465
973.189177
990.411773
950.986935
956.494921
976.867632
1011.353299
989.395859
909.109784
931.882778
952.690906
1008.204577
1018.280559
845.57162
932.438539
1017.372927
1001.275407
986.797225
979.926093
979.868989
980.841968
1038.354619
550.637184
603.041491
1001.802338
1000.878799
1004.885427
986.030282
990.138006
938.175836
994.987992
1007.147603
998.467567
1011.822203
1003.989168
748.627661
704.49654
546.128427
1010.984587
1017.370588
976.067069
971.587674
1012.514949
1021.072145
556.600518
1013.321596
999.455364
1025.942304
1003.351778
948.00582
1006.511627
963.000504
1038.313649
995.194061
1032.245063
1012.08568
585.385412
1000.654197
971.742902
550.282353
1020.316694
1017.406614
1003.652951
860.810609
1039.314016
1015.17429
839.095564
589.550967
998.290836
594.659692
564.153939
592.923145
548.71246
536.194103
1014.88365
1009.828241
550.38365
853.587775
1033.333193
1028.419299
1003.505907
1003.795614
1036.977346
1010.894517
1010.599761
1010.014036
561.96426
1015.633068
574.194418
915.543776
693.898554
868.78986
826.257568
999.211425
809.713957
567.571427
611.262971
1037.86259
1000.165756
580.102045
1006.101962
915.706346
772.971146
985.14522
1011.05164
1007.520578
1027.273211
985.5498
597.229498
1012.097045
574.216741
560.180499
776.628053
1038.212789
536.40585
959.407933
831.159679
1021.107153
1009.936491
1000.311559
1003.342712
982.370427
998.450695
1001.889622
1024.449727
801.133914
575.300207
1005.308986
1011.352132
970.185685
622.575119
1003.913461
579.233633
569.187886
994.438148
965.28398
1013.427162
1009.448022
921.761674
575.607895
622.796548
559.230919
563.641324
998.548485
1002.350399
999.169034
1011.015495
1014.706643
1039.175037
1036.848791
1016.947853
1017.068397
558.415172
1010.720653
863.081492
985.481326
998.785046
981.087162
551.095829
1014.968503
993.991543
1016.752224
1004.893921
1001.400343
1007.180449
987.96199
1021.479782
1001.409985
1023.665909
577.481431
1034.275774
1031.939739
966.665029
1002.535079
857.021243
580.024347
1004.066899
1018.784098
1019.572604
1036.582855
971.471674
1001.853244
599.083254
894.734875
1008.990814
1026.949536
1013.825164
1026.56719
589.469685
971.847268
1015.054724
1011.577641
1034.844339
994.349133
990.45732
1021.256097
1005.115668
475.669934
1020.939287
1000.798772
1008.732344
1013.680035
1002.787495
990.751771
1004.226545
1005.984215
1016.266849
1011.171077
1033.13184
1014.738181
998.533326
1016.969699
1016.560058
567.14512
1019.080468
988.415214
935.284829
892.135391
1010.978369
1007.97532
981.527302
993.925976
1010.931369
1026.700508
1009.423247
1012.127873
477.445407
1022.543123
1013.321868
1031.527419
1031.297443
974.756221
1012.015959
992.248656
1021.676358
665.587112
1015.304664
1003.227646
1009.804909
981.471793
1013.305649
1031.104868
1014.952736
1002.558736
986.567564
741.402024
594.105661
1038.758452
1006.624455
1019.796298
986.285723
744.789515
1009.323383
1026.953618
1021.212093
1006.304793
935.146141
560.771019
974.963614
1036.565266
1016.445
1037.85409
577.386244
628.728723
1026.430996
558.32294
653.599446
997.498688
1028.836275
604.698566
951.715188
1012.129391
546.872801
1040.277258
1006.002375
976.025677
1011.00368
1027.747682
1020.635989
975.662524
1003.756954
1007.208175
1006.407973
1005.917348
1033.279973
766.659476
1033.159221
1032.608132
1032.008814
853.906929
1015.78829
971.999852
884.142808
1004.512718
1010.071735
1009.350668
1027.420159
559.847754
983.518212
1017.358005
997.607413
996.472545
1009.881008
1037.244338
1007.045348
1023.423042
1019.23069
1015.608484
1044.20851
1022.063923
1020.059675
1025.709996
1022.535334
1023.692105
981.73891
1026.7586
1024.319898
1025.713713
1019.061465
1027.769502
546.614563
1032.143324
1044.18313
1025.221482
1033.929977
895.037476
419.290216
963.227951
568.284256
557.76996
1012.874505
1028.510033
1004.330104
1029.50626
1041.709798
600.248179
1022.111932
1030.568001
1019.740554
1040.237761
590.018151
894.099326
760.410613
1043.502966
576.408302
1040.185099
853.206436
561.928302
1005.216857
1025.290267
1040.612934
584.537647
1025.993881
566.753786
1017.652619
749.21094
1037.643565
1027.856273
1042.347286
939.802519
1036.996342
1041.132582
1030.553681
1038.839076
1030.380065
1022.046588
592.161838
1027.805206
1024.558322
1034.440759
1033.594968
673.662171
596.742047
1031.365654
1020.942613
565.527279
1034.652627
1001.22347
588.053716
616.847148
1025.667384
911.331881
569.227508
1006.843594
555.440389
571.185441
584.755161
1027.448755
1003.499517
1041.127692
607.772683
987.597405
1021.63521
1038.690539
591.874932
1034.306392
1022.442352
1008.435355
1041.355331
1014.731195
604.393943
1016.523966
1039.819706
1032.198151
1012.793827
565.401511
979.35918
1028.645499
1019.696111
1026.439223
677.746303
584.752831
1042.112813
1039.091574
926.588282
1032.415278
596.436525
847.154213
1035.342673
546.789485
583.311915
620.276853
744.804927
1042.008223
1029.47733
1037.613982
1013.056425
1008.201522
1035.267808
1040.762269
569.916825
1026.002736
602.949634
599.852615
1042.727136
1028.711675
981.619974
580.924316
660.337917
1042.560168
594.657705
1038.486745
1040.075211
1038.417159
599.093957
1013.65398
615.494324
596.50296
1018.360622
959.997863
579.383651
815.699684
583.599246
1028.16864
581.64323
607.632164
674.666051
1039.723123
1032.422913
1041.939562
1033.049073
1047.29122
1011.731397
1003.409918
1012.934415
580.733534
1033.170007
1037.021833
591.541716
1025.797464
1025.065788
1031.815255
1028.182482
1030.342904
1027.030396
754.116615
1008.788792
862.327508
514.341299
1017.583232
1019.155166
961.126598
1015.541171
130.302275
1023.764366
1024.171982
1030.796527
1009.278455
1024.923779
1040.678924
1023.713137
1020.192775
1010.392095
1027.305312
1012.147903
997.14144
1020.871087
1033.42365
1013.883193
610.716938
1027.023625
1006.181986
506.270791
990.399672
1021.912899
643.700974
1016.890151
489.827096
600.442595
486.092672
659.904967
1037.858635
1003.99733
1002.593385
1026.37495
1006.552841
1024.497799
1036.789643
1032.446929
632.58326
1034.966752
1013.487494
1027.870536
1006.978419
969.527233
1028.156036
1007.975316
650.083577
1007.374609
1026.060256
1000.109222
1035.800519
618.42217
1038.170764
1041.841598
559.090882
485.901967
602.163571
968.780738
1015.575284
955.564767
1030.406489
484.895206
633.424436
594.922021
1043.179472
642.254396
1040.029806
1019.417254
1030.586851
995.677969
1027.845757
609.753386
1025.389776
614.412749
605.202859
919.649332
617.7729
891.363613
898.89181
1030.755304
601.33041
504.606132
1018.639966
1038.255548
582.369879
567.216485
599.09209
1043.697044
666.763302
1029.404439
1021.699178
646.185195
1040.508141
669.184738
583.369017
748.019144
579.620544
1010.989084
674.560669
774.43871
1024.901245
904.980192
1019.510725
1029.317736
638.022923
807.982116
1043.711035
541.560358
1027.318143
1032.265235
1026.817629
1006.079035
433.838571
401.77452
1023.76016
1037.480137
1021.72992
591.467392
449.469366
1013.737242
1026.655122
664.644225
446.711602
749.438321
672.794282
1031.461251
1042.792739
639.492413
604.969132
1028.968994
922.767899
576.79877
1015.129004
657.651815
601.149741
602.127832
1002.986186
1020.528099
1007.568016
1025.503493
1027.447813
1014.830395
1023.495912
1024.813438
1005.538375
1018.914986
1013.108111
1005.830559
1040.286612
622.403969
567.244357
597.695469
1034.931296
1014.132996
1018.742182
661.503988
249.62894
899.979569
1005.801086
460.899565
1018.796585
1031.143142
1023.703067
1004.27296
1022.536076
1035.383527
901.78226
1019.719003
987.899091
1043.877621
467.816831
1024.763813
993.549032
1025.751429
906.725749
1020.916928
997.107996
1023.77665
477.094045
1030.130021
981.270548
584.024792
723.12525
1011.336678
1032.090772
150.972035
1005.706558
1010.358269
820.003606
1001.8909
1025.341562
489.600642
1013.143591
1020.726374
1004.720623
997.063291
1021.877798
1020.34509
949.018076
1033.097317
1040.676218
821.727764
1021.12132
1043.037059
970.017555
1013.529677
1022.512178
1043.258738
1019.796642
1043.265566
1015.962036
904.70484
595.758955
1001.43279
994.727448
1021.347317
1003.579195
537.576712
814.050344
1032.335295
1016.185347
1031.624787
1014.512041
1005.221389
1020.529171
604.844254
1013.713363
1013.667426
1032.381805
1019.471142
1025.612353
1007.470615
599.84371
1006.450765
995.629144
478.510322
1027.625874
1013.568433
1026.926053
590.155877
1015.253317
1016.363633
1024.462841
1036.251045
1022.357886
1014.682001
1018.116312
1030.373397
1041.057865
1042.110709
1031.726978
1043.058773
581.801824
1035.107054
1042.382382
1044.125241
613.847801
1033.356762
1032.006425
1043.095055
632.194816
1024.446308
1043.363696
1018.546217
669.612938
1022.149646
650.564681
1015.529156
1039.687668
1044.695492
1037.600059
1044.768506
1030.600984
1040.781866
1041.074301
1027.958206
497.493406
1032.359081
996.626336
1022.769472
1038.769302
647.50494
949.823242
1027.075388
1011.719814
659.168884
1042.958982
1016.742756
1032.978781
1024.526944
1019.093326
1032.800745
1017.950215
581.49735
1032.533321
1031.015393
638.262736
656.641288
1046.002609
922.042833
630.999717
1022.066185
660.872407
1039.78924
1037.464274
1043.795656
1031.522186
935.198169
666.0391
1024.999101
685.169673
1021.44846
994.693397
1024.731823
679.543833
613.230593
1004.326152
949.009261
1030.772383
520.089362
1022.141923
637.968824
1016.150141
1029.568212
1029.568212
1029.568212
1029.568212
1029.568212
1029.568212
1029.568212
1029.568212
1029.568212
1029.568212
"""
# 去除前后空白，并用换行符分割为列表
data_values = np.array([float(x) for x in data.split()])

# 计算滑动平均，这里使用的窗口大小为19
smoothed_values = np.convolve(data_values, np.ones(19)/19, mode='valid')

# 计算下采样的步长
step_size = int(len(smoothed_values) / 700)
x = np.arange(1, 1001)
# 执行下采样
downsampled_values = smoothed_values[::step_size]


# 原始x值
old_x = np.linspace(0, len(downsampled_values)-1, len(downsampled_values))

# 新的x值
new_x_3000 = np.linspace(0, len(downsampled_values)-1, 1000)

# 创建插值函数
interp_func_3000 = interp1d(old_x,downsampled_values)

# 使用插值函数计算新的y值
new_values_3000 = interp_func_3000(new_x_3000)

plt.figure(figsize=(10.24,7.9))  # 设置图像大小
plt.plot(x,new_values_3000, color=(0,0,0.6), linewidth=1.0)

plt.xlabel("Episodes", fontsize=25)
plt.ylabel("Reward", fontsize=25)
plt.tick_params(axis='both', labelsize=20)
plt.legend(fontsize=10)
plt.show()
